angular.module("horario")
.service('Sidebar', function()
{
    var sidebarIsShown = false;

    function toggleSidebar()
    {
        sidebarIsShown = !sidebarIsShown;
    }

    return {
        isSidebarShown: function()
        {
            return sidebarIsShown;
        },
        toggleSidebar: toggleSidebar
    };
})

.directive('horatime', function() { 
  return { 
    restrict: 'E', 
    link: function(scope, element, attrs) { 
    element.bind('click', function () {
      var horaelemento = 10;
      var minelemento = 32;
      var telemento = "am";
      if(element.text()!= "00:00"){
        var reloj = element.text().split(':');
        var relojH = Number(reloj[0]);
        horaelemento = relojH;

        if(relojH >= 12){
          telemento = "pm";
        }
        if(relojH > 12){
          horaelemento = relojH-12;
        }
        if(relojH == 24){
          telemento = "am";
        }
        minelemento = Number(reloj[1]);
      } // si funciona
      var contenido = "<div id='clock'><div class='clockBack'><div id='signalsH'><span id='plusH'>+</span><span id='minusH'>-</span></div><div id='signalsM' class='hide'><span id='plusM'>+</span><span id='minusM'>-</span></div><h1><span id='clockh' class='activeclock'>"+horaelemento+"</span>:<span id='clockm'>"+minelemento+"</span><span id='clockT'>"+telemento+"</span></h1><div id='clockContentH' class=''><div class='numbersBack' id='nos1'></div></div><div id='clockContentM' class='hide'><div class='numbersBack' id='nos2'></div></div><footer><a id='clockbtn1' class='btn btn--m btn--grey btn--flat' lx-ripple>Cancelar</a><a id='clockbtn2' class='btn btn--m tc-pink-400 btn--flat' lx-ripple>Aceptar</a></footer></div></div>";
      $('body').append(contenido);
      
      
      //var numbersBackH = "<div class='numbersBack'><span class='H1'>1</span><span class='H2'>2</span><span class='H3'>3</span><span class='H4'>4</span><span class='H5'>5</span><span class='H6'>6</span><span class='H7'>7</span><span class='H8'>8</span><span class='H9'>9</span><span class='H10'>10</span><span class='H11'>11</span><span class='H12'>12</span></div>";
      var isDragging = false;
      var $currentHandle = null;

      i=6
      m=30
      xmax=220; // ancho de lienzo
      ymax=220; // alto de lienzo
      xo=xmax/2; // Centro reloj coordenada x
      yo=ymax/2; // Centro reloj coordenada y
      radiox=xo-(xo/10); // Tamaño del radio ancho de la circunferencia
      radioy=yo-(yo/10); // Tamaño del radio alto de la circunferencia

      Math.degToRad = function(deg){ // Agregamos método a la clase estática
        return deg*Math.PI/180;
      }

      for (ang=0; ang<360; ang=ang+30){
        radianes=Math.degToRad(ang);
        x=radiox*Math.sin(radianes);
        y=radioy*Math.cos(radianes);
        x=x+xo;
        y=y+yo;
        m = ("0" + m).slice(-2)
        //i = ("0" + i).slice(-2)
        $('#nos1').append("<span class='numClockH' style='top:"+y+"px;left:"+x+"px'>"+i+"</span>");
        $('#nos2').append("<span class='numClockM' style='top:"+y+"px;left:"+x+"px'>"+m+"</span>");
        //var format="00" + number; format = format.substring(format.length - 3, format.length);
          
        m=Number(m);
        //Number(i)
        if(i==horaelemento){
          console.log(x+","+ y+" angulo "+ ang)
        }
        if(i==1)i=12 
          else i--
          if(m==0)m=55
          else m=m-5
      }
      function updateClockH(time){
        var minv = 1;
        var maxv = 12;
        var avance = 30; //grados
        var angulo = -90 + time*30
        var grados = Math.degToRad(time*30);
        /*var X = radiox*Math.sin(grados)+xo;
        var Y = radioy*Math.cos(grados)+yo;
        console.log("dos" +X+","+ Y+ " angulo "+ horaelemento*30)
        */
        var X = 98.2 + 100 * Math.sin(grados);
        var Y = 98 + 100 * -Math.cos(grados);
        $('#handHour').css({
        'left': X,
        'top': Y
        });
        $('#handTimeH').css({
        'left': X,
        'top': Y
        });
        $('#signHour').css({
          'transform': 'rotate('+angulo+'deg)'
        });
        /*$('#nos1 span:nth-child('+time+')').css({
          'background-color': 'rgba(218, 45, 124, 0.9)'
        });*/
        time = ("0" + time).slice(-2)
        $("#clockh").text(time);
      }

      $signalClockH = $("<div class='SignalsClock' id='reloj'></div>");
      $handleH = "<div class='circlelittle'></div><div id='handTimeH'></div><div class='handleClock' id='handHour'></div>";
      $signalsH = "<div class='signal' id='signHour'></div>";
      $signalClockM = $("<div class='SignalsClock'></div>");
      $handleM = "<div class='handleClock' id='handMin'></div>";
      $signalsM = "<div class='signal' id='signHour'></div>";
      $('#clockContentH').append($signalClockH);
      $signalClockH.append($handleH);
      $signalClockH.append($signalsH);
      $('#clockContentM').append($signalClockM);
      $signalClockM.append($handleM);
      $signalClockM.append($signalsM);

      updateClockH(horaelemento);

      $('#reloj').on('mousedown touchstart', '#handHour', function(e) {
        isDragging = true;
        console.log("clickqueado " + isDragging)
        e.preventDefault();
        $currentHandle = $(e.target);
        $(document).one('mouseup touchend', function() {

          isDragging = false;
          $currentHandle = null;
          console.log("fin click " + isDragging)
        });
      });
      
      $(".numClockH").bind('click', function () {
        var hor  = $(this).text();
        //$("#clockh").text(hor);
        updateClockH(hor);
       });
      $("#plusH").bind('click', function () {
        var hor  = Number($("#clockh").text());
        if (hor == 12) {
          hor = "0"+1;
        } else  {
          hor++;
          if(hor < 10){
            hor = "0"+hor;
          }  
        }
        //$("#clockh").text(hor);
        updateClockH(hor);
       });
       $("#minusH").bind('click', function () {
         var hor  = Number($("#clockh").text());
         if (hor == 1) {
          hor = 12;
          } else  {
            hor--;
            if(hor < 10){
              hor = "0"+hor;
            }
          }
        //$("#clockh").text(hor);
        updateClockH(hor);
       });
       $("#plusM").bind('click', function () {
        var min  = Number($("#clockm").text());
        if (min == 59) {
          min = "00";
        } else  {
          min++;
          if(min < 10){
            min = "0"+min;
          }  
        }
        $("#clockm").text(min);
       });
       $("#minusM").bind('click', function () {
         var min  = Number($("#clockm").text());
         if (min == 0) {
          min = 59;
          } else  {
            min--;
            if(min < 10){
              min = "0"+min;
            }
          }
        $("#clockm").text(min);
       });
      $("#clockm").bind('click', function () {
         $("#clockh").removeClass("activeclock");
         $("#signalsM").removeClass("hide");
         $("#clockm").addClass("activeclock");
         $("#signalsH").addClass("hide");
         $("#clockContentM").removeClass("hide");
         $("#clockContentH").addClass("hide");
      });
      $("#clockh").bind('click', function () {
        $("#clockh").addClass("activeclock");
        $("#signalsM").addClass("hide");
        $("#clockm").removeClass("activeclock");
        $("#clockContentH").removeClass("hide");
        $("#signalsH").removeClass("hide");
        $("#clockContentM").addClass("hide");
      });
      $("#clockT").bind('click', function () {
        $("#clockT").addClass("activeclock");
        setTimeout(function(){$("#clockT").removeClass("activeclock")}, 300);
        var utc = $("#clockT").text();
        if (utc == "am"){
          $("#clockT").text("pm")
        } else{
          $("#clockT").text("am")
        }
      });
      $("#clockbtn1").bind('click', function () {
        $('#clock').remove()
      });
      $("#clockbtn2").bind('click', function () {
        var hora = $("#clockh").text();
        var horaPM = Number(hora);
        var min = $("#clockm").text();
        var tiempo = $("#clockT").text();
        if(tiempo == "pm"){
          if(horaPM < 12){
            horaPM = Number(hora)+12;
            
          } else{
            horaPM = hora;
          }
        } else{ //estamos en am
          if(horaPM == 12){
            horaPM = Number(hora)+12;
          } 
          if(hora < 10){
            horaPM = "0"+Number(hora);
          }
        }
        element.text(horaPM+":"+min);
        var clockTime= horaPM+":"+min;
        $('#clock').remove();
      });

      $(document).on('mousemove touchmove', function (e) {
        if (isDragging) {

          var $draggingTarget = $(e.target);

          $draggingWrapper = $draggingTarget.closest('#clockContentH');
          if ($draggingWrapper.length === 0) {
            return;
          }

          $draggingHandle = $draggingWrapper.find('.handleClock');
        

          if ($draggingHandle[0] !== $currentHandle[0]) {
            return;
          }


          var $container = $currentHandle.closest('#clockContentH');
          var radius = 98;

          if (!e.offsetX && e.originalEvent.touches) {
            // touch events
            var targetOffset = $draggingTarget.offset();
            e.offsetX = e.originalEvent.touches[0].pageX - targetOffset.left;
            e.offsetY = e.originalEvent.touches[0].pageY - targetOffset.top;
          }
          else if(typeof e.offsetX === "undefined" || typeof e.offsetY === "undefined") {
            // firefox compatibility
            var targetOffset = $draggingTarget.offset();
            e.offsetX = e.pageX - targetOffset.left;
            e.offsetY = e.pageY - targetOffset.top;
          }

          if ($draggingTarget.hasClass('handleClock')) {
            var mPos = {
              x: e.target.offsetLeft + e.offsetX,
              y: e.target.offsetTop + e.offsetY
            };
          }
          else {
            var mPos = {
              x: e.offsetX,
              y: e.offsetY
            };
          }

          var atan = Math.atan2(mPos.x - radius, mPos.y - radius);
          var deg = -atan / (Math.PI / 180) + 180; // final (0-360 positive) degrees from mouse position

          var steps = 12 - 0;
          var stepSize = 360/steps;

          var value = Math.round(deg/stepSize);
          //if (value == maxValue) {
          //  value = minValue;
          //}
          //if()
          updateClockH(value);

        }
      });



    }); //aqui termina el click principal
     
    } 
  }; 
})

.directive('backButton', function(){ 
  return { 
    restrict: 'A', 
    link: function(scope, element, attrs) { 
      element.bind('click', function () { 
        history.back(); 
        scope.$apply(); 
      });
    }
  } 
})
.directive('horamovida', function(){
  return function(scope, element){
    $(window).scroll(function(){
      element.css({
        'top': -$(this).scrollTop()+106//+15//Why this 15, because in the CSS, we have set left 15, so as we scroll, we would want this to remain at 15px left
      });
    });
  }
})
.directive('headTable', function(){
  return function(scope, element){
    $('#container').scroll(function(){
      $('#tableHead').css({
        'left': -$(this).scrollLeft(),
        'transition':' all 0s'//+15//Why this 15, because in the CSS, we have set left 15, so as we scroll, we would want this to remain at 15px left
      });
    });
  }
})
.directive('ancla', function(){ 
  return { 
    restrict: 'A',
    link: function(scope, element, attrs) {
      element.css({
        'height': '36px',
        'width':'36px',
        'padding': '5px',
        'margin-top': '3px',
        'transition':' all 0.7s'//+15//Why this 15, because in the CSS, we have set left 15, so as we scroll, we would want this to remain at 15px left
      });
      $('.l').css({
        'background-color': '#fff',
        'margin': '3px',
        'width':'20px',
        'height': '2px',
        'transition':' all 0.7s',
        'border-radius': '1px'//+15//Why this 15, because in the CSS, we have set left 15, so as we scroll, we would want this to remain at 15px left
      });
      $('#uno').css({
      'margin-top': '6px'
    });

      /*element.bind('click', function () { 
        console.log(scope.barramain)
        if(scope.barramain == true){
        } else{
          
        } 
        console.log("dio click")
      });*/
    }
  } 
})

.directive('scrollShrink', function(){
    return function(scope,element,attrs){
        attrs.$observe('scrollShrink', function(value){
            fab = $("#"+value)

            var didScroll;
            var lastScrollTop = 0;
            var delta = 5;
            var navbarHeight = element.outerHeight();
            var fabHeight = fab.outerHeight();

            $(window).scroll(function(event){
                didScroll = true;
            });

            setInterval(function() {
                if (didScroll) {
                    hasScrolled();
                    didScroll = false;
                }
            }, 250);

            function hasScrolled() {
                var st = $(this).scrollTop();
                // Make sure they scroll more than delta
                if(Math.abs(lastScrollTop - st) <= delta)
                    return;
                
                // If they scrolled down and are past the navbar, add class .nav-up.
                // This is necessary so you never see what is "behind" the navbar.
                if (st > lastScrollTop && st > navbarHeight){
                    // Scroll Down
                    element.css({
                        'transform': 'translate3d(0,-'+navbarHeight+'px,0)',
                        'transition':' all 0.5s ease-in-out'
                    });
                   $('#tableHead').css({
                        'transform': 'translate3d(0,-'+navbarHeight+'px,0)',
                        'transition':' all 0.5s ease-in-out'
                    });
                    $('#ocultahead').css({
                        'transform': 'translate3d(0,-'+navbarHeight+'px,0)',
                        'transition':' all 0.5s ease-in-out'
                    });
                    fab.css({
                        'transform': 'translate3d(0,'+(fabHeight+15)+'px,0)',
                        'transition':' all 0.5s ease-in-out'
                    });
                } else {
                    // Scroll Up
                    if(st + $(window).height() < $(document).height()) {
                        element.css({
                        'transform': 'translate3d(0,0,0)'
                        });
                       $('#tableHead').css({
                        'transform': 'translate3d(0,0,0)'
                        });
                       $('#ocultahead').css({
                        'transform': 'translate3d(0,0,0)'
                        });
                        fab.css({
                        'transform': 'translate3d(0,0,0)',
                        'transition':' all 0.5s ease-in-out'
                        });
                    }
                }
                lastScrollTop = st;
            }
        });
    };
})


.factory('indexedDBDataSvc', function($window, $q){
  var indexedDB = $window.indexedDB;
  var db=null;
  var lastIndexh=0, lastIndexs=0, lastIndexn=0;
  var error1 = "La base de datos aún no ha sido abierta!";
  var langNave = window.navigator.language||navigator.browserLanguage;
  var lang = langNave.split('-');
  var multilang;
  if (lang[0] == "es"){
    multilang = "es";
  } else if(lang[0] == "pt"){
    multilang = "pt";
  } else {
    multilang = "en";
  }
  var open = function(){
    var deferred = $q.defer();
    var version = 2;
    var request = indexedDB.open("mihorario", version);
  
    request.onupgradeneeded = function(e) {
      db = e.target.result;
  
      e.target.transaction.onerror = indexedDB.onerror;
  
      if(db.objectStoreNames.contains("table")) {
        db.deleteObjectStore("table");
      }
      if(db.objectStoreNames.contains("subject")) {
        db.deleteObjectStore("subject");
      }
      if(db.objectStoreNames.contains("notes")) {
        db.deleteObjectStore("notes");
      }
      if(db.objectStoreNames.contains("config")) {
        db.deleteObjectStore("config");
      }
        db.createObjectStore("hours", {keyPath: "id"});
        db.createObjectStore("subjects", {keyPath: "id"});
        db.createObjectStore("notes", {keyPath: "id"});
       var store = db.createObjectStore("config", {keyPath: "opc"}, {value: "opc"});

       store.put({"opc": "config", "day": "vie", "alert": "1", "noti": true, "multilang": multilang});
       window.location.replace('#/welcome');
    };
  
    request.onsuccess = function(e) {
      db = e.target.result;
      deferred.resolve();
    };
  
    request.onerror = function(){
      deferred.reject();
    };
    
    return deferred.promise;
  }; //aqui termina open
  
  var getHoras = function(){
    var deferred = $q.defer();
    
    if(db === null){
      deferred.reject(error1);
    }
    else{
      var trans = db.transaction(["hours"], "readwrite");
      var store = trans.objectStore("hours");
      var horacolor = [];
      var horas = [];
    
      // Get everything in the store;
      var keyRange = IDBKeyRange.lowerBound(0);
      var cursorRequest = store.openCursor(keyRange);
    
      cursorRequest.onsuccess = function(e) {
        var result = e.target.result;
        if(result === null || result === undefined)
        {
          deferred.resolve(horas);
        }
        else{
          horas.push(result.value);
          if(result.value.id > lastIndexh){
            lastIndexh=result.value.id;
          }
          result.continue();
        }
      };
    
      cursorRequest.onerror = function(e){
        console.log(e.value);
        deferred.reject("Algo ha salido mal!!!");
      };
    }
    
    return deferred.promise;
  }; //aqui termina getHoras
  var getSubjects = function(){
    var deferred = $q.defer();
    
    if(db === null){
      deferred.reject(error1);
    }
    else{
      var trans = db.transaction(["subjects"], "readwrite");
      var store = trans.objectStore("subjects");
      var subjects = [];
    
      // Get everything in the store;
      var keyRange = IDBKeyRange.lowerBound(0);
      var cursorRequest = store.openCursor(keyRange);
    
      cursorRequest.onsuccess = function(e) {
        var result = e.target.result;
        if(result === null || result === undefined)
        {
          deferred.resolve(subjects);
        }
        else{
          subjects.push(result.value);
          if(result.value.id > lastIndexs){
            lastIndexs=result.value.id;
          }
          result.continue();
        }
      };
    
      cursorRequest.onerror = function(e){
        console.log(e.value);
        deferred.reject("Algo ha salido mal!!!");
      };
    }
    
    return deferred.promise;
  }; //aqui termina getSubjects
  var getNotes = function(){
    var deferred = $q.defer();
    
    if(db === null){
      deferred.reject(error1);
    }
    else{
      var trans = db.transaction(["notes"], "readwrite");
      var store = trans.objectStore("notes");
      var notes = [];
    
      // Get everything in the store;
      var keyRange = IDBKeyRange.lowerBound(0);
      var cursorRequest = store.openCursor(keyRange);
    
      cursorRequest.onsuccess = function(e) {
        var result = e.target.result;
        if(result === null || result === undefined)
        {
          deferred.resolve(notes);
        }
        else{
          notes.push(result.value);
          if(result.value.id > lastIndexn){
            lastIndexn=result.value.id;
          }
          result.continue();
        }
      };
    
      cursorRequest.onerror = function(e){
        console.log(e.value);
        deferred.reject("Algo ha salido mal!!!");
      };
    }
    
    return deferred.promise;
  }; //aqui termina getSubjects
  var getHora = function(id){
    var deferred = $q.defer();
    var hora = "";
    db.transaction("hours").objectStore("hours").get(id).onsuccess = function(event) {
      hora = event.target.result;
      deferred.resolve(hora);
      };
    return deferred.promise;
  }; //aqui termina gethora

  var getSubject = function(id){
    var deferred = $q.defer();
    var materia = "";
    db.transaction("subjects").objectStore("subjects").get(id).onsuccess = function(event) {
      materia = event.target.result;
      deferred.resolve(materia);
      };
    return deferred.promise;
  }; //aqui termina getSubject
  var getNote = function(id){
    var deferred = $q.defer();
    var note = "";
    db.transaction("notes").objectStore("notes").get(id).onsuccess = function(event) {
      note = event.target.result;
      deferred.resolve(note);
      };
    return deferred.promise;
  }; //aqui termina getSubject

  var getConfig = function(opc){
    var deferred = $q.defer();
    var config = "";
    db.transaction("config").objectStore("config").get(opc).onsuccess = function(event) {
      config = event.target.result;
      deferred.resolve(config);
      };
    return deferred.promise;
  };

  var deleteHora = function(id){
    var deferred = $q.defer();
    
    if(db === null){
      deferred.reject(error1);
    }
    else{
      var trans = db.transaction(["hours"], "readwrite");
      var store = trans.objectStore("hours");
    
      var request = store.delete(id);
    
      request.onsuccess = function(e) {
        deferred.resolve();
      };
    
      request.onerror = function(e) {
        console.log(e.value);
        deferred.reject("El item no pudo ser eliminado");
      };
    }
    
    return deferred.promise;
  };

   var deleteSubject = function(id){
    var deferred = $q.defer();
    
    if(db === null){
      deferred.reject(error1);
    }
    else{
      var trans = db.transaction(["subjects"], "readwrite");
      var store = trans.objectStore("subjects");
    
      var request = store.delete(id);
    
      request.onsuccess = function(e) {
        deferred.resolve();
      };
    
      request.onerror = function(e) {
        console.log(e.value);
        deferred.reject("El la materia no pudo ser eliminada");
      };
    }
    
    return deferred.promise;
  };
  var deleteNote = function(id){
    var deferred = $q.defer();
    
    if(db === null){
      deferred.reject(error1);
    }
    else{
      var trans = db.transaction(["notes"], "readwrite");
      var store = trans.objectStore("notes");
    
      var request = store.delete(id);
    
      request.onsuccess = function(e) {
        deferred.resolve();
      };
    
      request.onerror = function(e) {
        console.log(e.value);
        deferred.reject("La nota no pudo ser eliminada");
      };
    }
    
    return deferred.promise;
  };
  var editHora = function(todo){
    var deferred = $q.defer();
    
    if(db === null){
      deferred.reject(error1);
    }
    else{
      var trans = db.transaction(["hours"], "readwrite");
      var store = trans.objectStore("hours");
      var horanew = todo;
      var requestUpdate = store.put(horanew);
    
      requestUpdate.onsuccess = function(e) {
        deferred.resolve();
      };
    
      requestUpdate.onerror = function(e) {
        console.log(e.value);
        deferred.reject("El item no pudo ser editado");
      };
    }
    
    return deferred.promise;
  };
  var editSubject = function(todo){
    var deferred = $q.defer();
    
    if(db === null){
      deferred.reject(error1);
    }
    else{
      var trans = db.transaction(["subjects"], "readwrite");
      var store = trans.objectStore("subjects");
      var matnew = todo;
      var requestUpdate = store.put(matnew);
    
      requestUpdate.onsuccess = function(e) {
        deferred.resolve();
      };
    
      requestUpdate.onerror = function(e) {
        console.log(e.value);
        deferred.reject("El item no pudo ser editado");
      };
    }
    
    return deferred.promise;
  };
  var editNote = function(todo){
    var deferred = $q.defer();
    
    if(db === null){
      deferred.reject(error1);
    }
    else{
      var trans = db.transaction(["notes"], "readwrite");
      var store = trans.objectStore("notes");
      var notnew = todo;
      var requestUpdate = store.put(notnew);
    
      requestUpdate.onsuccess = function(e) {
        deferred.resolve();
      };
    
      requestUpdate.onerror = function(e) {
        console.log(e.value);
        deferred.reject("El item no pudo ser editado");
      };
    }
    
    return deferred.promise;
  };
  var addHora = function(hour, hour2, mon, tue, wed, thu, fri, sat, sund){
    var deferred = $q.defer();
    
    if(db === null){
      deferred.reject(error1);
    }
    else{
      var trans = db.transaction(["hours"], "readwrite");
      var store = trans.objectStore("hours");
      lastIndexh++;
      var request = store.add({
        "id": lastIndexh,
        "hora": hour,
        "hora2": hour2,
        "lun": mon,
        "clun": "grey-200",
        "mar": tue,
        "cmar": "grey-200",
        "mie": wed,
        "cmie": "grey-200",
        "jue": thu,
        "cjue": "grey-200",
        "vie": fri,
        "cvie": "grey-200",
        "sab": sat,
        "csab": "grey-200",
        "dom": sund,
        "cdom": "grey-200"
      });
    
      request.onsuccess = function(e) {
        deferred.resolve();
      };
    
      request.onerror = function(e) {
        console.log(e.value);
        deferred.reject("El item no pudo ser añadido");
      };
    }
    return deferred.promise;
  };
  var addSubject = function(name, prof, aula, color){
    var deferred = $q.defer();
    
    if(db === null){
      deferred.reject(error1);
    }
    else{
      var trans = db.transaction(["subjects"], "readwrite");
      var store = trans.objectStore("subjects");
      lastIndexs++;
      var request = store.add({
        "id": lastIndexs,
        "titulo": name,
        "profe": prof,
        "aula": aula,
        "color": color
      });
    
      request.onsuccess = function(e) {
        deferred.resolve();
      };
    
      request.onerror = function(e) {
        console.log(e.value);
        deferred.reject("El item no pudo ser añadido");
      };
    }
    return deferred.promise;
  };
  var addNote = function(titulo, descripcion, prioridad, fecha){
    var deferred = $q.defer();
    
    if(db === null){
      deferred.reject(error1);
    }
    else{
      var trans = db.transaction(["notes"], "readwrite");
      var store = trans.objectStore("notes");
      lastIndexn++;
      var request = store.add({
        "id": lastIndexn,
        "titulo": titulo,
        "descripcion": descripcion,
        "prioridad": prioridad,
        "fecha": fecha
      });
    
      request.onsuccess = function(e) {
        deferred.resolve();
      };
    
      request.onerror = function(e) {
        console.log(e.value);
        deferred.reject("El item no pudo ser añadido");
      };
    }
    return deferred.promise;
  };
  
  var saveConfig = function(day, alert, noti, langSave){
    var deferred = $q.defer();
    if(db === null){
      deferred.reject(error1);
    }
    else{
      var trans = db.transaction(["config"], "readwrite");
      var store = trans.objectStore("config");
      var request = store.put({
        "opc": "config", 
        "day": day, 
        "alert": alert, 
        "noti": noti,
        "multilang": langSave
      });
      request.onsuccess = function(e) {
        deferred.resolve();
      };
      request.onerror = function(e) {
        console.log(e.value);
        deferred.reject("La configuración no pudo ser guardada");
      };
    }
    return deferred.promise;
  };
  return {
    open: open,
    getHoras: getHoras,
    getSubjects: getSubjects,
    getNotes: getNotes,
    getHora: getHora,
    getSubject: getSubject,
    getNote: getNote,
    getConfig: getConfig,
    addHora: addHora,
    addSubject: addSubject,
    addNote: addNote,
    saveConfig: saveConfig,
    deleteHora: deleteHora,
    deleteSubject: deleteSubject,
    deleteNote: deleteNote,
    editHora: editHora,
    editSubject: editSubject,
    editNote: editNote
  };
  
})

.service('colorMeta', function(){
  var codeHex;
  var colores = [
    { cod: 'blue', hex: '#2196F3'},
    { cod: 'red', hex: '#F44336'},
    { cod: 'pink', hex: '#E91E63'},
    { cod: 'purple', hex: '#9C27B0'},
    { cod: 'deep-purple', hex: '#673AB7'},
    { cod: 'indigo', hex: '#3F51B5'},
    { cod: 'light-blue', hex: '#00BCD4'},
    { cod: 'teal', hex: '#009688'},
    { cod: 'green', hex: '#4CAF50'},
    { cod: 'light-green', hex: '#8BC34A'},
    { cod: 'lime', hex: '#CDDC39'},
    { cod: 'yellow', hex: '#FFEB3B'},
    { cod: 'amber', hex: '#FFC107'},
    { cod: 'orange', hex: '#FF9800'},
    { cod: 'deep-orange', hex: '#FF5722'},
    { cod: 'brown', hex: '#795548'},
    { cod: 'grey', hex: '#9E9E9E'},
    { cod: 'blue-grey', hex: '#607D8B'}
  ];

  this.getColor = function(color){
    for (i = 0; i<colores.length; i++){
      var colorin = colores[i].cod;
      if (color == colorin){
        codeHex = colores[i].hex;
      } else{
        colorin = codeHex = "#EEEEEE";
      }
    }
    return codeHex
  }
});